#include 	"NPH_RX_MCU.h"
#include	"typedef.h"
#include	"main.h"
#include	"led.h"

#pragma	rambank0
bit	f8ms;
bit	fKeyDeb;
bit	fKeyTyp;
bit	fKeyPrs;
bit	fPairing;
bit	fPaired;
#if	(_TEST_DISTANCE_==1)
bit	fDistance;
#endif
#pragma	norambank

#if	(_TEST_DISTANCE_==1)
u8		mRxDataO;
u8		mRxCnt;
#endif

u8 mKeyBuf;
u8 mKeyDeb;
u8	mRFAddr[4];
u8	mRFRvData;

void main()
{
	_csel = 0;
	_cos = 1;
	//b[7:5]=CKS2 ~ CKS0, IDLEN=0, HLCLK=1 (fSYS=fH=8MHz)
	_smod = 0x01;			//fSYS have to equal to 8MHz for NPH RX decoding
			
	clrRAM();
	initIO();
	initLEDPort();	
	
	//b[7:5]=CKS2 ~ CKS0, IDLEN=0, HLCLK=1 (fSYS=fH=8MHz)
	_smod = 0x01;			//fSYS have to equal to 8MHz for NPH RX decoding
	EN_WDT(WDT_1s);

	RF_Configuration();	//RF configuration	
	
	fPaired = readRFAddrFrmEE();	//paired or not
	initTB1();
    
	if(fPaired)
	{	
		Enable_RX();	//enable RF receive mode
		initLEDPattern(c_PAIRED_LED, c_PAIRED_ON_TIME, c_PAIRED_OFF_TIME, c_PAIRED_TIMES);
	}
	else
		initLEDPattern(c_UNPAIRED_LED, c_UNPAIRED_ON_TIME, c_UNPAIRED_OFF_TIME, c_UNPAIRED_TIMES);

#if	(_TEST_DISTANCE_==1)
	fDistance = 1;
#endif
	_emi = 1;

	
	while(1)
	{	
		_clrwdt();
		if(chkKey2Pairing())		//If key pressed to pairing
		{
			clearRFAddrInEE();	//clear the RF address, saved in EEPROM
			fPairing = 1;			//set fPairing flag to indicate in pairing mode			
			initLEDPattern(c_PAIRING_LED, c_PAIRING_ON_TIME, c_PAIRING_OFF_TIME, c_PAIRING_TIMES);
			Enable_RX();			//enable RF receive mode
		}
		
		if(f_RX_Frm)				//whether id RF frame received
		{
			Read_RF_AddrDta();	//read received RF address and data to buffer mRFData[3:0]
			if(f_RX_Dta)			//whether is RF data valid
			{
				Clr_RX_Dta_Flag();	//clear f_RX_Dta flag

				if(fPairing)			//whether in pairing mode
				{
					fPairing = 0;		//paire down and clear fPairing flag 
					mRFAddr[0] = mRFData[0];	//save RF address to mRFAddr[2:0] buffer
					mRFAddr[1] = mRFData[1];	//
					mRFAddr[2] = mRFData[2];	//
					saveRFAddr2EE();	//save RF address mRFAddr[2:0] to EEPROM	
				}

				if(chkRFAddr())		//whether RF address is the same with self
				{
					mRFRvData = mRFData[3];	//save RF received data to mRFRvData buffer
#if	(_TEST_DISTANCE_==1)
					updateDistanceDta();
#endif
					initLEDPattern(mRFRvData, c_DATA_ON_TIME, c_DATA_OFF_TIME, c_DATA_TIMES);
				}
			}
		}
		
		if(f8ms)
		{
			f8ms = 0;
			if(mKeyDeb)
				mKeyDeb--;
			updateLED();
		}

		if(chk2Halt())
		{
			DIS_WDT();
			_halt();
			EN_WDT(WDT_1s);
		}
	}
}

//-------------------------------------------------------
void	clrRAM(void)
{
	_bp = 0;
	for(_tblp = 0; _tblp < 2; _tblp++)
	{
		_mp1=0x80;
		while(_mp1 != 0)
		{
			_iar1=0;
			_mp1++;
		}
		_bp++;
	}	
}

//-------------------------------------------------------
void	initIO(void)
{
	//PA7=LED, PA[6:4]=Key, PA3=DIN
	_pawu = 0x70;		
	_papu = 0x70;		
	_pa = 0x70;			
	_pac = 0x70;
	
	//PB6=CLK, PB[4:3]=LED, PB[2:1]=option 
	_pb = 0x3D;			
	_pbc = 0x06;
	_pbpu = 0x06;
	
	//PC[1:0]=option
	_pc = 0x03;
	_pcc = 0x03;
	_pcpu = 0x03;		
}

//-------------------------------------------------------
void	initTB1(void)
{
	_tbc = 0x00;		//TB0=8ms, TB1=125ms
	_tb0e = 1;
	_tbon = 1;
}

//-------------------------------------------------------
u8	chkKey2Pairing(void)
{
	u8    mKeyBufT;

	mKeyBufT = (c_KEY_PORT ^ 0xFF) & c_KEY_MASK;
	if(mKeyBuf != mKeyBufT)
	{
		mKeyBuf = mKeyBufT;
		mKeyDeb = c_KEY_DEB;
		fKeyDeb = 1;
		fKeyTyp = 0;
	}
	
	if(mKeyDeb == 0)
	{
		if(mKeyBuf & c_KEY_MASK)
			fKeyPrs = 1;
		else
			fKeyPrs = 0;
			
		if(fKeyDeb)
		{
			fKeyDeb = 0;
			if(fKeyPrs && (mKeyBuf & c_KEY1))
			{
				mKeyDeb = c_KEY_LEARN_TIME;
				fKeyTyp = 1;
			}
		}
		else
		{
			if(fKeyTyp)
			{
				fKeyTyp = 0;
				return 0x01;
			}
		}		
	}
	return 0x00;
}

//-------------------------------------------------------
u8	readEEPROM(u8	addr)
{
	_eea = addr;
	_mp1 = 0x40;		//setup memory pointer MP1
	_bp = 1;				//setup Bank Pointer
	_iar1 |= 0x02;		//set RDEN bit, enable read operations
	_iar1 |= 0x01; 	//start Read Cycle - set RD bit
	while(_iar1 & 0x01);
	_iar1 = 0;
	_bp = 0;
	return _eed;
}

//-------------------------------------------------------
void	writeEEPROM(u8	addr, u8 dta)
{
	_eed = dta;
	_eea = addr;
	_mp1 = 0x40;		//setup memory pointer MP1
	_bp = 1;				//setup Bank Pointer
	
	_emi = 0;
	_iar1 |= 0x08;		//set WREN bit, enable write operations
	_iar1 |= 0x04; 	//start Write Cycle - set WR bit!V executed immediately after
	while(_iar1 & 0x04);
	_emi = 1;
	
	_iar1 = 0;
	_bp = 0;
}

//-------------------------------------------------------
void	clearRFAddrInEE(void)
{
	u8 i;
	
	for(i=0; i<4; i++)
	{
		writeEEPROM(i, 0x00); 	
	}
}

//-------------------------------------------------------
void	saveRFAddr2EE(void)
{
	u8 addr, i;
	
	addr = 0;
	mRFAddr[3] = 0xFF;
	for(i=0; i<3; i++)
	{
		mRFAddr[3] ^= mRFAddr[i];
		writeEEPROM(i, mRFAddr[i]); 	
	}
	writeEEPROM(3, mRFAddr[3]);
}

//-------------------------------------------------------
u8	readRFAddrFrmEE(void)
{
	u8 sum, i;
	
	sum = 0xFF;
	for(i=0; i<4; i++)
	{
		mRFAddr[i] = readEEPROM(i); 
		sum ^= mRFAddr[i];	
	}
	if(sum==0)
		return 1;
	else
		return 0;
}

//-------------------------------------------------------
u8	chkRFAddr(void)
{
	u8	i;
	
	for(i=0; i<3; i++)
	{
		if(mRFData[i] != mRFAddr[i])
			return	0;
	}
	return	1;
}

//-------------------------------------------------------
#if	(_TEST_DISTANCE_==1)
void	updateDistanceDta(void)
{
	if(fDistance)
	{
		if(mRFRvData > mRxDataO)
			mRxCnt++;
		else
			mRxCnt = 0;
		mRxDataO = mRFRvData;
		if(mRxCnt < 80)
			mRFRvData = 0x01;
		else if (mRxCnt < 90)
			mRFRvData = 0x03;
		else
			mRFRvData = 0x07;
	}
}
#endif

//-------------------------------------------------------
u8	chk2Halt(void)
{
	return (!f_RX_Running && !fKeyDeb && !fKeyPrs && !chkLEDSts());	
}
